<?php $__env->startSection('titlepage', 'Laporan Presensi'); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('navigasi'); ?>
    <span>Laporan Presensi</span>
<?php $__env->stopSection(); ?>
<div class="row">
    <div class="col-lg-6 col-sm-12 col-xs-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('laporan.cetakpresensi')); ?>" method="POST" target="_blank" id="formPresensi">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-3">
                        <select name="kode_cabang" id="kode_cabang_presensi" class="form-select select2Kodecabangpresensi">
                            <option value="">Semua Cabang</option>
                            <?php $__currentLoopData = $cabang; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($d->kode_cabang); ?>"><?php echo e(textUpperCase($d->nama_cabang)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <select name="kode_dept" id="kode_dept_presensi" class="form-select select2Kodedeptpresensi">
                            <option value="">Semua Departemen</option>
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <select name="periode_laporan" id="periode_laporan" class="form-select">
                            <option value="">Periode Laporan</option>
                            <option value="1" selected>Periode Gaji</option>
                            <option value="2">Bulan Berjalan</option>
                        </select>
                    </div>
                    

                    <div class="row">
                        <div class="col">
                            <div class="form-group mb-3">
                                <select name="bulan" id="bulan" class="form-select">
                                    <option value="">Bulan</option>
                                    <?php $__currentLoopData = $list_bulan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(date('m') == $d['kode_bulan'] ? 'selected' : ''); ?> value="<?php echo e($d['kode_bulan']); ?>">
                                            <?php echo e($d['nama_bulan']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="co">
                            <div class="form-group mb-3">
                                <select name="tahun" id="tahun" class="form-select">
                                    <option value="">Tahun</option>
                                    <?php for($t = $start_year; $t <= date('Y'); $t++): ?>
                                        <option <?php echo e(date('Y') == $t ? 'selected' : ''); ?> value="<?php echo e($t); ?>"><?php echo e($t); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-10 col-md-12 col-sm-12">
                            <button type="submit" name="submitButton" class="btn btn-primary w-100" id="submitButton">
                                <i class="ti ti-printer me-1"></i> Cetak
                            </button>
                        </div>
                        <div class="col-lg-2 col-md-12 col-sm-12">
                            <button type="submit" name="exportButton" class="btn btn-success w-100" id="exportButton">
                                <i class="ti ti-download"></i>
                            </button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('myscript'); ?>
<script>
    $(function() {
        const select2Kodecabangpresensi = $(".select2Kodecabangpresensi");
        if (select2Kodecabangpresensi.length) {
            select2Kodecabangpresensi.each(function() {
                var $this = $(this);
                $this.wrap('<div class="position-relative"></div>').select2({
                    placeholder: 'Semua Cabang',
                    allowClear: true,
                    dropdownParent: $this.parent()
                });
            });
        }


        $("#formPresensi").submit(function(e) {
            const periode_laporan = $("#periode_laporan").val();
            const bulan = $(this).find("#bulan").val();
            const tahun = $(this).find("#tahun").val();
            if (periode_laporan == "") {
                Swal.fire({
                    icon: 'warning',
                    title: 'Oops...',
                    text: 'Periode Laporan harus diisi!',
                    showConfirmButton: true,
                    didClose: () => {
                        $("#periode_laporan").focus();
                    }
                });
                return false;
            } else if (bulan == "") {
                Swal.fire({
                    icon: 'warning',
                    title: 'Oops...',
                    text: 'Bulan harus diisi!',
                    showConfirmButton: true,
                    didClose: () => {
                        $("#bulan").focus();
                    }
                });
                return false;
            } else if (tahun == "") {
                Swal.fire({
                    icon: 'warning',
                    title: 'Oops...',
                    text: 'Tahun harus diisi!',
                    showConfirmButton: true,
                    didClose: () => {
                        $("#tahun").focus();
                    }
                });
                return false;
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\v2\presensiv2-main\resources\views/laporan/presensi.blade.php ENDPATH**/ ?>